/* Scintilla text editing control
 * Contributed by Andy Friesen
 *
 * A lot of this was autogenerated with a badly hacked interface thing.
 * Ugly, but easy to keep up to date.
 */

module net.BurtonRadons.dig.platform.scintilla;

private import net.BurtonRadons.dig.platform.base;
private import net.BurtonRadons.dig.platform.control;
private import net.BurtonRadons.dig.platform.windows; 

//private import net.BurtonRadons.dig.windows.windows; 

//private import std.c.windows.windows;


/+
#ifdef DoxygenDoesntNeedToSeeThis
+/

template ScintillaListenerType(T1)
{
    alias void delegate(T1 t1) Func;

    struct Listener
    {
        protected Func[Func] _listeners;       // set of delegates

        void add(Func func)
        {
            _listeners[func] = func;
        }
        
        void erase(Func func)
        {
            if (func in _listeners)
                delete _listeners[func];
        }
        
        void fire(T1 t1)
        {
            Func[] f = _listeners.keys;
            for (int i = 0; i < f.length; i++)
                f[i](t1);
        }
    }
}

struct ScintillaEventArgs
{
    NMHDR nmhdr;
    
    int position;       // SCN_STYLENEEDED, SCN_MODIFIED, SCN_DWELLSTART, SCN_DWELLEND
    int ch;             // SCN_CHARADDED, SCN_KEY
    int modifiers;      // SCN_KEY
    int modificationType;       // SCN_MODIFIED
    char *text;         // SCN_MODIFIED
    int length;         // SCN_MODIFIED
    int linesAdded;     // SCN_MODIFIED
    int message;        // SCN_MACRORECORD
    void* wParam;       // SCN_MACRORECORD
    void* lParam;       // SCN_MACRORECORD
    int line;           // SCN_MODIFIED
    int foldLevelNow;   // SCN_MODIFIED
    int foldLevelPrev;  // SCN_MODIFIED
    int margin;         // SCN_MARGINCLICK
    int listType;       // SCN_USERLISTSELECTION
    int x;              // SCN_DWELLSTART, SCN_DWELLEND
    int y;              // SCN_DWELLSTART, SCN_DWELLEND
}

alias instance ScintillaListenerType(ScintillaEventArgs).Listener ScintillaListener;

/+
#endif
+/

/** A Scintilla (http://scintilla.org) syntax-highlighting text editor control.
  * This is not visible using "import net.BurtonRadons.dig.main";
  * "import net.BurtonRadons.dig.scintilla" must also
  * be used.
  */

class ScintillaText : Control
{
/+
#ifdef DoxygenMustSkipThis
+/
    static _HMODULE digPlatformLibrary;
    
    extern (C) alias int (*digPlatformDirectFuncType)(void* p, int a, int b, int c);
    digPlatformDirectFuncType digPlatformDirectFunc;
    void *digPlatformPointer;
    
/+
#endif
+/

    /** Call the Scintilla control. */
    int call (int a, int b, int c)
    {
        return digPlatformDirectFunc (digPlatformPointer, a, b, c);
    }
    
    // interface
    public
    {
        static const int SCI_GETDIRECTFUNCTION = 2184;
        static const int SCI_GETDIRECTPOINTER = 2185;

        this(Control parent)
        {
            super(parent);
            
            if (!digPlatformLibrary)
                digPlatformLibrary = std.c.windows.windows.LoadLibraryA("scilexer.dll");
            if (!digPlatformLibrary)
                throw new Exception("SciLexer.dll is required for Scintilla.");
            
            digPlatformStyle |= WS_VISIBLE | WS_CHILD | std.c.windows.windows.ES_AUTOHSCROLL;
            digPlatformHWNDCreate(WS_EX_CLIENTEDGE, "Scintilla", null, digPlatformStyle, (_HANDLE) 0);
            
            digPlatformPointer = cast(void*)SendMessageA(digPlatformHWND, SCI_GETDIRECTPOINTER, 0, 0);
            digPlatformDirectFunc = cast(digPlatformDirectFuncType) SendMessageA (digPlatformHWND, SCI_GETDIRECTFUNCTION, 0, 0);
            assert (digPlatformPointer);
            assert (digPlatformDirectFunc);
        }

//++Autogenerated
        int notify(NMHDR* nmhdr)
        {
            ScintillaEventArgs* args = cast(ScintillaEventArgs*)nmhdr;
            switch (nmhdr.code)
            {
                case SCN_STYLENEEDED: StyleNeeded.fire(*args); break; 
                case SCN_CHARADDED: CharAdded.fire(*args); break; 
                case SCN_SAVEPOINTREACHED: SavePointReached.fire(*args); break; 
                case SCN_SAVEPOINTLEFT: SavePointLeft.fire(*args); break; 
                case SCN_MODIFYATTEMPTRO: ModifyAttemptRO.fire(*args); break; 
                case SCN_KEY: Key.fire(*args); break; 
                case SCN_DOUBLECLICK: DoubleClick.fire(*args); break; 
                case SCN_UPDATEUI: UpdateUI.fire(*args); break; 
                case SCN_MODIFIED: Modified.fire(*args); break; 
                case SCN_MACRORECORD: MacroRecord.fire(*args); break; 
                case SCN_MARGINCLICK: MarginClick.fire(*args); break; 
                case SCN_NEEDSHOWN: NeedShown.fire(*args); break; 
                case SCN_PAINTED: Painted.fire(*args); break; 
                case SCN_USERLISTSELECTION: UserListSelection.fire(*args); break; 
                case SCN_URIDROPPED: URIDropped.fire(*args); break; 
                case SCN_DWELLSTART: DwellStart.fire(*args); break; 
                case SCN_DWELLEND: DwellEnd.fire(*args); break; 
                case SCN_ZOOM: Zoom.fire(*args); break; 
            }
            return 0;
        }

        void AddText(int length, char[] text) { call(2001, length, cast(int)&text[0]); }
        void AddStyledText(int length, void* c) { call(2002, length, cast (int)c); }
        void InsertText(uint pos, char[] text) { call(2003, pos, cast(int)&text[0]); }
        void ClearAll() { call(2004, 0, 0); }
        void ClearDocumentStyle() { call(2005, 0, 0); }
        int GetLength() { return call(2006, 0, 0); }
        int GetCharAt(uint pos) { return call(2007, pos, 0); }
        uint GetCurrentPos() { return call(2008, 0, 0); }
        uint GetAnchor() { return call(2009, 0, 0); }
        int GetStyleAt(uint pos) { return call(2010, pos, 0); }
        void Redo() { call(2011, 0, 0); }
        void SetUndoCollection(bit collectUndo) { call(2012, cast (int)collectUndo, 0); }
        void SelectAll() { call(2013, 0, 0); }
        void SetSavePoint() { call(2014, 0, 0); }
        int GetStyledText(ScintillaTextRange tr) { return call(2015, 0, cast(int)&tr); }
        bit CanRedo() { return cast(bit)call(2016, 0, 0); }
        int MarkerLineFromHandle(int handle) { return call(2017, handle, 0); }
        void MarkerDeleteHandle(int handle) { call(2018, handle, 0); }
        bit GetUndoCollection() { return cast(bit)call(2019, 0, 0); }
        int GetViewWS() { return call(2020, 0, 0); }
        void SetViewWS(int viewWS) { call(2021, viewWS, 0); }
        int PositionFromPoint(int x, int y) { return call(2022, x, y); }
        int PositionFromPointClose(int x, int y) { return call(2023, x, y); }
        void GotoLine(int line) { call(2024, line, 0); }
        void GotoPos(uint pos) { call(2025, pos, 0); }
        void SetAnchor(uint posAnchor) { call(2026, posAnchor, 0); }
        int GetCurLine(int length, char[] text) { return call(2027, length, cast(int)&text[0]); }
        uint GetEndStyled() { return call(2028, 0, 0); }
        void ConvertEOLs(int eolMode) { call(2029, eolMode, 0); }
        int GetEOLMode() { return call(2030, 0, 0); }
        void SetEOLMode(int eolMode) { call(2031, eolMode, 0); }
        void StartStyling(uint pos, int mask) { call(2032, pos, mask); }
        void SetStyling(int length, int style) { call(2033, length, style); }
        bit GetBufferedDraw() { return cast(bit)call(2034, 0, 0); }
        void SetBufferedDraw(bit buffered) { call(2035, cast (int)buffered, 0); }
        void SetTabWidth(int tabWidth) { call(2036, tabWidth, 0); }
        int GetTabWidth() { return call(2121, 0, 0); }
        void SetCodePage(int codePage) { call(2037, codePage, 0); }
        void SetUsePalette(bit usePalette) { call(2039, cast (int)usePalette, 0); }
        void MarkerDefine(int markerNumber, int markerSymbol) { call(2040, markerNumber, markerSymbol); }
        void MarkerSetFore(int markerNumber, uint fore) { call(2041, markerNumber, fore); }
        void MarkerSetBack(int markerNumber, uint back) { call(2042, markerNumber, back); }
        int MarkerAdd(int line, int markerNumber) { return call(2043, line, markerNumber); }
        void MarkerDelete(int line, int markerNumber) { call(2044, line, markerNumber); }
        void MarkerDeleteAll(int markerNumber) { call(2045, markerNumber, 0); }
        int MarkerGet(int line) { return call(2046, line, 0); }
        int MarkerNext(int lineStart, int markerMask) { return call(2047, lineStart, markerMask); }
        int MarkerPrevious(int lineStart, int markerMask) { return call(2048, lineStart, markerMask); }
        void MarkerDefinePixmap(int markerNumber, char[] pixmap) { call(2049, markerNumber, cast(int)&pixmap[0]); }
        void SetMarginTypeN(int margin, int marginType) { call(2240, margin, marginType); }
        int GetMarginTypeN(int margin) { return call(2241, margin, 0); }
        void SetMarginWidthN(int margin, int pixelWidth) { call(2242, margin, pixelWidth); }
        int GetMarginWidthN(int margin) { return call(2243, margin, 0); }
        void SetMarginMaskN(int margin, int mask) { call(2244, margin, mask); }
        int GetMarginMaskN(int margin) { return call(2245, margin, 0); }
        void SetMarginSensitiveN(int margin, bit sensitive) { call(2246, margin, cast (int)sensitive); }
        bit GetMarginSensitiveN(int margin) { return cast(bit)call(2247, margin, 0); }
        void StyleClearAll() { call(2050, 0, 0); }
        void StyleSetFore(int style, uint fore) { call(2051, style, fore); }
        void StyleSetBack(int style, uint back) { call(2052, style, back); }
        void StyleSetBold(int style, bit bold) { call(2053, style, cast (int)bold); }
        void StyleSetItalic(int style, bit italic) { call(2054, style, cast (int)italic); }
        void StyleSetSize(int style, int sizePoints) { call(2055, style, sizePoints); }
        void StyleSetFont(int style, char[] fontName) { call(2056, style, cast(int)&fontName[0]); }
        void StyleSetEOLFilled(int style, bit filled) { call(2057, style, cast (int)filled); }
        void StyleResetDefault() { call(2058, 0, 0); }
        void StyleSetUnderline(int style, bit underline) { call(2059, style, cast (int)underline); }
        void StyleSetCase(int style, int caseForce) { call(2060, style, caseForce); }
        void StyleSetCharacterSet(int style, int characterSet) { call(2066, style, characterSet); }
        void SetSelFore(bit useSetting, uint fore) { call(2067, cast (int)useSetting, fore); }
        void SetSelBack(bit useSetting, uint back) { call(2068, cast (int)useSetting, back); }
        void SetCaretFore(uint fore) { call(2069, fore, 0); }
        void AssignCmdKey(uint km, int msg) { call(2070, km, msg); }
        void ClearCmdKey(uint km) { call(2071, km, 0); }
        void ClearAllCmdKeys() { call(2072, 0, 0); }
        void SetStylingEx(int length, char[] styles) { call(2073, length, cast(int)&styles[0]); }
        void StyleSetVisible(int style, bit visible) { call(2074, style, cast (int)visible); }
        int GetCaretPeriod() { return call(2075, 0, 0); }
        void SetCaretPeriod(int periodMilliseconds) { call(2076, periodMilliseconds, 0); }
        void SetWordChars(char[] characters) { call(2077, 0, cast(int)&characters[0]); }
        void BeginUndoAction() { call(2078, 0, 0); }
        void EndUndoAction() { call(2079, 0, 0); }
        void IndicSetStyle(int indic, int style) { call(2080, indic, style); }
        int IndicGetStyle(int indic) { return call(2081, indic, 0); }
        void IndicSetFore(int indic, uint fore) { call(2082, indic, fore); }
        uint IndicGetFore(int indic) { return call(2083, indic, 0); }
        void SetWhitespaceFore(bit useSetting, uint fore) { call(2084, cast (int)useSetting, fore); }
        void SetWhitespaceBack(bit useSetting, uint back) { call(2085, cast (int)useSetting, back); }
        void SetStyleBits(int bits) { call(2090, bits, 0); }
        int GetStyleBits() { return call(2091, 0, 0); }
        void SetLineState(int line, int state) { call(2092, line, state); }
        int GetLineState(int line) { return call(2093, line, 0); }
        int GetMaxLineState() { return call(2094, 0, 0); }
        bit GetCaretLineVisible() { return cast(bit)call(2095, 0, 0); }
        void SetCaretLineVisible(bit show) { call(2096, cast (int)show, 0); }
        uint GetCaretLineBack() { return call(2097, 0, 0); }
        void SetCaretLineBack(uint back) { call(2098, back, 0); }
        void StyleSetChangeable(int style, bit changeable) { call(2099, style, cast (int)changeable); }
        void AutoCShow(int lenEntered, char[] itemList) { call(2100, lenEntered, cast(int)&itemList[0]); }
        void AutoCCancel() { call(2101, 0, 0); }
        bit AutoCActive() { return cast(bit)call(2102, 0, 0); }
        uint AutoCPosStart() { return call(2103, 0, 0); }
        void AutoCComplete() { call(2104, 0, 0); }
        void AutoCStops(char[] characterSet) { call(2105, 0, cast(int)&characterSet[0]); }
        void AutoCSetSeparator(int separatorCharacter) { call(2106, separatorCharacter, 0); }
        int AutoCGetSeparator() { return call(2107, 0, 0); }
        void AutoCSelect(char[] text) { call(2108, 0, cast(int)&text[0]); }
        void AutoCSetCancelAtStart(bit cancel) { call(2110, cast (int)cancel, 0); }
        bit AutoCGetCancelAtStart() { return cast(bit)call(2111, 0, 0); }
        void AutoCSetFillUps(char[] characterSet) { call(2112, 0, cast(int)&characterSet[0]); }
        void AutoCSetChooseSingle(bit chooseSingle) { call(2113, cast (int)chooseSingle, 0); }
        bit AutoCGetChooseSingle() { return cast(bit)call(2114, 0, 0); }
        void AutoCSetIgnoreCase(bit ignoreCase) { call(2115, cast (int)ignoreCase, 0); }
        bit AutoCGetIgnoreCase() { return cast(bit)call(2116, 0, 0); }
        void UserListShow(int listType, char[] itemList) { call(2117, listType, cast(int)&itemList[0]); }
        void AutoCSetAutoHide(bit autoHide) { call(2118, cast (int)autoHide, 0); }
        bit AutoCGetAutoHide() { return cast(bit)call(2119, 0, 0); }
        void AutoCSetDropRestOfWord(bit dropRestOfWord) { call(2270, cast (int)dropRestOfWord, 0); }
        bit AutoCGetDropRestOfWord() { return cast(bit)call(2271, 0, 0); }
        void RegisterImage(int type, int xpmData) { call(2405, type, xpmData); }
        void SetIndent(int indentSize) { call(2122, indentSize, 0); }
        int GetIndent() { return call(2123, 0, 0); }
        void SetUseTabs(bit useTabs) { call(2124, cast (int)useTabs, 0); }
        bit GetUseTabs() { return cast(bit)call(2125, 0, 0); }
        void SetLineIndentation(int line, int indentSize) { call(2126, line, indentSize); }
        int GetLineIndentation(int line) { return call(2127, line, 0); }
        uint GetLineIndentPosition(int line) { return call(2128, line, 0); }
        int GetColumn(uint pos) { return call(2129, pos, 0); }
        void SetHScrollBar(bit show) { call(2130, cast (int)show, 0); }
        bit GetHScrollBar() { return cast(bit)call(2131, 0, 0); }
        void SetIndentationGuides(bit show) { call(2132, cast (int)show, 0); }
        bit GetIndentationGuides() { return cast(bit)call(2133, 0, 0); }
        void SetHighlightGuide(int column) { call(2134, column, 0); }
        int GetHighlightGuide() { return call(2135, 0, 0); }
        int GetLineEndPosition(int line) { return call(2136, line, 0); }
        int GetCodePage() { return call(2137, 0, 0); }
        uint GetCaretFore() { return call(2138, 0, 0); }
        bit GetUsePalette() { return cast(bit)call(2139, 0, 0); }
        bit GetReadOnly() { return cast(bit)call(2140, 0, 0); }
        void SetCurrentPos(uint pos) { call(2141, pos, 0); }
        void SetSelectionStart(uint pos) { call(2142, pos, 0); }
        uint GetSelectionStart() { return call(2143, 0, 0); }
        void SetSelectionEnd(uint pos) { call(2144, pos, 0); }
        uint GetSelectionEnd() { return call(2145, 0, 0); }
        void SetPrintMagnification(int magnification) { call(2146, magnification, 0); }
        int GetPrintMagnification() { return call(2147, 0, 0); }
        void SetPrintColourMode(int mode) { call(2148, mode, 0); }
        int GetPrintColourMode() { return call(2149, 0, 0); }
        uint FindText(int flags, ScintillaTextToFind ft) { return call(2150, flags, cast(int)&ft); }
        void FormatRange(bit draw, void* fr) { call(2151, cast (int)draw, cast (int)fr); }
        int GetFirstVisibleLine() { return call(2152, 0, 0); }
        int GetLine(int line, char[] text) { return call(2153, line, cast(int)&text[0]); }
        int GetLineCount() { return call(2154, 0, 0); }
        void SetMarginLeft(int pixelWidth) { call(2155, 0, pixelWidth); }
        int GetMarginLeft() { return call(2156, 0, 0); }
        void SetMarginRight(int pixelWidth) { call(2157, 0, pixelWidth); }
        int GetMarginRight() { return call(2158, 0, 0); }
        bit GetModify() { return cast(bit)call(2159, 0, 0); }
        void SetSel(uint start, uint end) { call(2160, start, end); }
        int GetSelText(char[] text) { return call(2161, 0, cast(int)&text[0]); }
        int GetTextRange(ScintillaTextRange tr) { return call(2162, 0, cast(int)&tr); }
        void HideSelection(bit normal) { call(2163, cast (int)normal, 0); }
        int PointXFromPosition(uint pos) { return call(2164, 0, pos); }
        int PointYFromPosition(uint pos) { return call(2165, 0, pos); }
        int LineFromPosition(uint pos) { return call(2166, pos, 0); }
        int PositionFromLine(int line) { return call(2167, line, 0); }
        void LineScroll(int columns, int lines) { call(2168, columns, lines); }
        void ScrollCaret() { call(2169, 0, 0); }
        void ReplaceSel(char[] text) { call(2170, 0, cast(int)&text[0]); }
        void SetReadOnly(bit readOnly) { call(2171, cast (int)readOnly, 0); }
        void Null() { call(2172, 0, 0); }
        bit CanPaste() { return cast(bit)call(2173, 0, 0); }
        bit CanUndo() { return cast(bit)call(2174, 0, 0); }
        void EmptyUndoBuffer() { call(2175, 0, 0); }
        void Undo() { call(2176, 0, 0); }
        void Cut() { call(2177, 0, 0); }
        void Copy() { call(2178, 0, 0); }
        void Paste() { call(2179, 0, 0); }
        void Clear() { call(2180, 0, 0); }
        void SetText(char[] text) { call(2181, 0, cast(int)&text[0]); }
        int GetText(int length, char[] text) { return call(2182, length, cast(int)&text[0]); }
        int GetTextLength() { return call(2183, 0, 0); }
        int GetDirectFunction() { return call(2184, 0, 0); }
        int GetDirectPointer() { return call(2185, 0, 0); }
        void SetOvertype(bit overtype) { call(2186, cast (int)overtype, 0); }
        bit GetOvertype() { return cast(bit)call(2187, 0, 0); }
        void SetCaretWidth(int pixelWidth) { call(2188, pixelWidth, 0); }
        int GetCaretWidth() { return call(2189, 0, 0); }
        void SetTargetStart(uint pos) { call(2190, pos, 0); }
        uint GetTargetStart() { return call(2191, 0, 0); }
        void SetTargetEnd(uint pos) { call(2192, pos, 0); }
        uint GetTargetEnd() { return call(2193, 0, 0); }
        int ReplaceTarget(int length, char[] text) { return call(2194, length, cast(int)&text[0]); }
        int ReplaceTargetRE(int length, char[] text) { return call(2195, length, cast(int)&text[0]); }
        int SearchInTarget(int length, char[] text) { return call(2197, length, cast(int)&text[0]); }
        void SetSearchFlags(int flags) { call(2198, flags, 0); }
        int GetSearchFlags() { return call(2199, 0, 0); }
        void CallTipShow(uint pos, char[] definition) { call(2200, pos, cast(int)&definition[0]); }
        void CallTipCancel() { call(2201, 0, 0); }
        bit CallTipActive() { return cast(bit)call(2202, 0, 0); }
        uint CallTipPosStart() { return call(2203, 0, 0); }
        void CallTipSetHlt(int start, int end) { call(2204, start, end); }
        void CallTipSetBack(uint back) { call(2205, back, 0); }
        int VisibleFromDocLine(int line) { return call(2220, line, 0); }
        int DocLineFromVisible(int lineDisplay) { return call(2221, lineDisplay, 0); }
        void SetFoldLevel(int line, int level) { call(2222, line, level); }
        int GetFoldLevel(int line) { return call(2223, line, 0); }
        int GetLastChild(int line, int level) { return call(2224, line, level); }
        int GetFoldParent(int line) { return call(2225, line, 0); }
        void ShowLines(int lineStart, int lineEnd) { call(2226, lineStart, lineEnd); }
        void HideLines(int lineStart, int lineEnd) { call(2227, lineStart, lineEnd); }
        bit GetLineVisible(int line) { return cast(bit)call(2228, line, 0); }
        void SetFoldExpanded(int line, bit expanded) { call(2229, line, cast (int)expanded); }
        bit GetFoldExpanded(int line) { return cast(bit)call(2230, line, 0); }
        void ToggleFold(int line) { call(2231, line, 0); }
        void EnsureVisible(int line) { call(2232, line, 0); }
        void SetFoldFlags(int flags) { call(2233, flags, 0); }
        void EnsureVisibleEnforcePolicy(int line) { call(2234, line, 0); }
        void SetTabIndents(bit tabIndents) { call(2260, cast (int)tabIndents, 0); }
        bit GetTabIndents() { return cast(bit)call(2261, 0, 0); }
        void SetBackSpaceUnIndents(bit bsUnIndents) { call(2262, cast (int)bsUnIndents, 0); }
        bit GetBackSpaceUnIndents() { return cast(bit)call(2263, 0, 0); }
        void SetMouseDwellTime(int periodMilliseconds) { call(2264, periodMilliseconds, 0); }
        int GetMouseDwellTime() { return call(2265, 0, 0); }
        int WordStartPosition(uint pos, bit onlyWordCharacters) { return call(2266, pos, cast (int)onlyWordCharacters); }
        int WordEndPosition(uint pos, bit onlyWordCharacters) { return call(2267, pos, cast (int)onlyWordCharacters); }
        void SetWrapMode(int mode) { call(2268, mode, 0); }
        int GetWrapMode() { return call(2269, 0, 0); }
        void SetLayoutCache(int mode) { call(2272, mode, 0); }
        int GetLayoutCache() { return call(2273, 0, 0); }
        void SetScrollWidth(int pixelWidth) { call(2274, pixelWidth, 0); }
        int GetScrollWidth() { return call(2275, 0, 0); }
        int TextWidth(int style, char[] text) { return call(2276, style, cast(int)&text[0]); }
        void SetEndAtLastLine(bit endAtLastLine) { call(2277, cast (int)endAtLastLine, 0); }
        int GetEndAtLastLine() { return call(2278, 0, 0); }
        int TextHeight(int line) { return call(2279, line, 0); }
        void SetVScrollBar(bit show) { call(2280, cast (int)show, 0); }
        bit GetVScrollBar() { return cast(bit)call(2281, 0, 0); }
        void AppendText(int length, char[] text) { call(2282, length, cast(int)&text[0]); }
        void LineDown() { call(2300, 0, 0); }
        void LineDownExtend() { call(2301, 0, 0); }
        void LineUp() { call(2302, 0, 0); }
        void LineUpExtend() { call(2303, 0, 0); }
        void CharLeft() { call(2304, 0, 0); }
        void CharLeftExtend() { call(2305, 0, 0); }
        void CharRight() { call(2306, 0, 0); }
        void CharRightExtend() { call(2307, 0, 0); }
        void WordLeft() { call(2308, 0, 0); }
        void WordLeftExtend() { call(2309, 0, 0); }
        void WordRight() { call(2310, 0, 0); }
        void WordRightExtend() { call(2311, 0, 0); }
        void Home() { call(2312, 0, 0); }
        void HomeExtend() { call(2313, 0, 0); }
        void LineEnd() { call(2314, 0, 0); }
        void LineEndExtend() { call(2315, 0, 0); }
        void DocumentStart() { call(2316, 0, 0); }
        void DocumentStartExtend() { call(2317, 0, 0); }
        void DocumentEnd() { call(2318, 0, 0); }
        void DocumentEndExtend() { call(2319, 0, 0); }
        void PageUp() { call(2320, 0, 0); }
        void PageUpExtend() { call(2321, 0, 0); }
        void PageDown() { call(2322, 0, 0); }
        void PageDownExtend() { call(2323, 0, 0); }
        void EditToggleOvertype() { call(2324, 0, 0); }
        void Cancel() { call(2325, 0, 0); }
        void DeleteBack() { call(2326, 0, 0); }
        void Tab() { call(2327, 0, 0); }
        void BackTab() { call(2328, 0, 0); }
        void NewLine() { call(2329, 0, 0); }
        void FormFeed() { call(2330, 0, 0); }
        void VCHome() { call(2331, 0, 0); }
        void VCHomeExtend() { call(2332, 0, 0); }
        void ZoomIn() { call(2333, 0, 0); }
        void ZoomOut() { call(2334, 0, 0); }
        void DelWordLeft() { call(2335, 0, 0); }
        void DelWordRight() { call(2336, 0, 0); }
        void LineCut() { call(2337, 0, 0); }
        void LineDelete() { call(2338, 0, 0); }
        void LineTranspose() { call(2339, 0, 0); }
        void LineDuplicate() { call(2404, 0, 0); }
        void LowerCase() { call(2340, 0, 0); }
        void UpperCase() { call(2341, 0, 0); }
        void LineScrollDown() { call(2342, 0, 0); }
        void LineScrollUp() { call(2343, 0, 0); }
        void DeleteBackNotLine() { call(2344, 0, 0); }
        void HomeDisplay() { call(2345, 0, 0); }
        void HomeDisplayExtend() { call(2346, 0, 0); }
        void LineEndDisplay() { call(2347, 0, 0); }
        void LineEndDisplayExtend() { call(2348, 0, 0); }
        void MoveCaretInsideView() { call(2401, 0, 0); }
        int LineLength(int line) { return call(2350, line, 0); }
        void BraceHighlight(uint pos1, uint pos2) { call(2351, pos1, pos2); }
        void BraceBadLight(uint pos) { call(2352, pos, 0); }
        uint BraceMatch(uint pos) { return call(2353, pos, 0); }
        bit GetViewEOL() { return cast(bit)call(2355, 0, 0); }
        void SetViewEOL(bit visible) { call(2356, cast (int)visible, 0); }
        int GetDocPointer() { return call(2357, 0, 0); }
        void SetDocPointer(int pointer) { call(2358, 0, pointer); }
        void SetModEventMask(int mask) { call(2359, mask, 0); }
        int GetEdgeColumn() { return call(2360, 0, 0); }
        void SetEdgeColumn(int column) { call(2361, column, 0); }
        int GetEdgeMode() { return call(2362, 0, 0); }
        void SetEdgeMode(int mode) { call(2363, mode, 0); }
        uint GetEdgeColour() { return call(2364, 0, 0); }
        void SetEdgeColour(uint edgeColour) { call(2365, edgeColour, 0); }
        void SearchAnchor() { call(2366, 0, 0); }
        int SearchNext(int flags, char[] text) { return call(2367, flags, cast(int)&text[0]); }
        int SearchPrev(int flags, char[] text) { return call(2368, flags, cast(int)&text[0]); }
        int LinesOnScreen() { return call(2370, 0, 0); }
        void UsePopUp(bit allowPopUp) { call(2371, cast (int)allowPopUp, 0); }
        bit SelectionIsRectangle() { return cast(bit)call(2372, 0, 0); }
        void SetZoom(int zoom) { call(2373, zoom, 0); }
        int GetZoom() { return call(2374, 0, 0); }
        int CreateDocument() { return call(2375, 0, 0); }
        void AddRefDocument(int doc) { call(2376, 0, doc); }
        void ReleaseDocument(int doc) { call(2377, 0, doc); }
        int GetModEventMask() { return call(2378, 0, 0); }
        void SetFocus(bit focus) { call(2380, cast (int)focus, 0); }
        bit GetFocus() { return cast(bit)call(2381, 0, 0); }
        void SetStatus(int statusCode) { call(2382, statusCode, 0); }
        int GetStatus() { return call(2383, 0, 0); }
        void SetMouseDownCaptures(bit captures) { call(2384, cast (int)captures, 0); }
        bit GetMouseDownCaptures() { return cast(bit)call(2385, 0, 0); }
        void SetCursor(int cursorType) { call(2386, cursorType, 0); }
        int GetCursor() { return call(2387, 0, 0); }
        void SetControlCharSymbol(int symbol) { call(2388, symbol, 0); }
        int GetControlCharSymbol() { return call(2389, 0, 0); }
        void WordPartLeft() { call(2390, 0, 0); }
        void WordPartLeftExtend() { call(2391, 0, 0); }
        void WordPartRight() { call(2392, 0, 0); }
        void WordPartRightExtend() { call(2393, 0, 0); }
        void SetVisiblePolicy(int visiblePolicy, int visibleSlop) { call(2394, visiblePolicy, visibleSlop); }
        void DelLineLeft() { call(2395, 0, 0); }
        void DelLineRight() { call(2396, 0, 0); }
        void SetXOffset(int newOffset) { call(2397, newOffset, 0); }
        int GetXOffset() { return call(2398, 0, 0); }
        void ChooseCaretX() { call(2399, 0, 0); }
        void GrabFocus() { call(2400, 0, 0); }
        void SetXCaretPolicy(int caretPolicy, int caretSlop) { call(2402, caretPolicy, caretSlop); }
        void SetYCaretPolicy(int caretPolicy, int caretSlop) { call(2403, caretPolicy, caretSlop); }
        void StartRecord() { call(3001, 0, 0); }
        void StopRecord() { call(3002, 0, 0); }
        void SetLexer(int lexer) { call(4001, lexer, 0); }
        int GetLexer() { return call(4002, 0, 0); }
        void Colourise(uint start, uint end) { call(4003, start, end); }
        void SetProperty(char[] key, char[] value) { call(4004, cast(int)&key[0], cast(int)&value[0]); }
        void SetKeyWords(int keywordSet, char[] keyWords) { call(4005, keywordSet, cast(int)&keyWords[0]); }
        void SetLexerLanguage(char[] language) { call(4006, 0, cast(int)&language[0]); }

        enum : uint
        {
            SCN_STYLENEEDED = 2000,
            SCN_CHARADDED = 2001,
            SCN_SAVEPOINTREACHED = 2002,
            SCN_SAVEPOINTLEFT = 2003,
            SCN_MODIFYATTEMPTRO = 2004,
            SCN_KEY = 2005,
            SCN_DOUBLECLICK = 2006,
            SCN_UPDATEUI = 2007,
            SCN_MODIFIED = 2008,
            SCN_MACRORECORD = 2009,
            SCN_MARGINCLICK = 2010,
            SCN_NEEDSHOWN = 2011,
            SCN_PAINTED = 2013,
            SCN_USERLISTSELECTION = 2014,
            SCN_URIDROPPED = 2015,
            SCN_DWELLSTART = 2016,
            SCN_DWELLEND = 2017,
            SCN_ZOOM = 2018,
        }

        enum : uint
        {
            LexPython = 2,
            LexCpp = 3,
            LexHTML = 4,
            LexXML = 5,
            LexPerl = 6,
            LexSQL = 7,
            LexVB = 8,
            LexProperties = 9,
            LexErrorList = 10,
            LexMakeFile = 11,
            LexBatch = 12,
            LexLaTeX = 14,
            LexLua = 15,
            LexDiff = 16,
            LexConf = 17,
            LexPascal = 18,
            LexAvenue = 19,
            LexAda = 20,
            LexLisp = 21,
            LexRuby = 22,
            LexEiffel = 23,
            LexEiffelKW = 24,
            LexTCL = 25,
            LexNNCronTab = 26,
            LexBullAnt = 27,
            LexVBScript = 28,
            LexASP = 29,
            LexPHP = 30,
            LexBaan = 31,
            LexMatLab = 32,
            LexSol = 33,
            LexAsm = 34,
            LexFortran = 36,
            LexF77 = 37,
            LexCSS = 38,
        }

        ScintillaListener StyleNeeded;
        ScintillaListener CharAdded;
        ScintillaListener SavePointReached;
        ScintillaListener SavePointLeft;
        ScintillaListener ModifyAttemptRO;
        ScintillaListener Key;
        ScintillaListener DoubleClick;
        ScintillaListener UpdateUI;
        ScintillaListener Modified;
        ScintillaListener MacroRecord;
        ScintillaListener MarginClick;
        ScintillaListener NeedShown;
        ScintillaListener Painted;
        ScintillaListener UserListSelection;
        ScintillaListener URIDropped;
        ScintillaListener DwellStart;
        ScintillaListener DwellEnd;
        ScintillaListener Zoom;
//--Autogenerated
    }
}

/+
#ifdef DoxygenDoesntNeedToSeeThis
+/

struct ScintillaCharacterRange
{
    long cpMin;
    long cpMax;
}

struct ScintillaTextRange
{
    ScintillaCharacterRange chrg;
    char *lpstrText;
}

struct ScintillaTextToFind
{
    ScintillaCharacterRange chrg;
    char *lpstrText;
    ScintillaCharacterRange chrgText;
}

/+
#endif
+/